#!/usr/bin/python
import sys
from collections import Counter, defaultdict
from urlparse import urlparse, parse_qs

METRIC_NAME = 'smartcache-worker_timings_lag_get_a3_smartcache-update-snapshot'
METRIC_NAME_BY_OPERATION = 'smartcache-worker_timings_lag_get_a3_smartcache-update-snapshot_by_operation'
METRIC_NAME_BY_ACTION = 'smartcache-worker_timings_lag_get_a3_smartcache-update-snapshot_by_action'

lag_by_action = defaultdict(Counter)
lag_by_operation = defaultdict(Counter)
lag_total = Counter()


def get_counter_line(counter):
    return ' '.join(map(lambda t: "%s@%s" % t, sorted(counter.items())))


for logline in sys.stdin:
    parsed_line = logline.split()
    logline_unixtime = int(parsed_line[0])
    request_field = parsed_line[1]
    if 'smartcache-update-snapshot' not in request_field:
        continue
    parsed_request = urlparse(request_field)
    parsed_query_params = parse_qs(parsed_request.query)
    search_request_timestamp = int(parsed_query_params['request_ts'][0])
    action = parsed_query_params['action'][0]
    operation = parsed_query_params['operation'][0]
    lag = logline_unixtime - search_request_timestamp
    lag_total[lag] += 1
    lag_by_action[action][lag] += 1
    lag_by_operation[operation][lag] += 1

for action in lag_by_action:
    if lag_by_action[action]:
        print '@{}.{} {}'.format(METRIC_NAME_BY_ACTION, action, get_counter_line(lag_by_action[action]))

for operation in lag_by_operation:
    if lag_by_operation[operation]:
        print '@{}.{} {}'.format(METRIC_NAME_BY_OPERATION, operation, get_counter_line(lag_by_operation[operation]))

if lag_total:
    print '@{} {}'.format(METRIC_NAME, get_counter_line(lag_total))
