#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import sys
import re
from pprint import pprint
from collections import defaultdict
import time


results_errors = { 'parse' : 0 }

# Collect errors from logs
results_log_errors = dict()
for error in ['parse']:
    results_log_errors[error] = 0


results_count_pg_op_status = defaultdict(dict)
results_timings_pg_op = defaultdict(list)


results_count_aggr_pg_op_status = defaultdict(dict)
results_timings_aggr_pg_op = defaultdict(list)




# message=Task mpfs.core.job_handlers.push.handle_push_notification/7e6d5183-a670-45b3-b7eb-dcfdedbfbfec resubmitted into disk_xiva
celery_td_re = re.compile('Task (?P<task_name>[^\/]+)/[^ ]+ resubmitted into (?P<queue_name>[^$]+)$')


# 

#pg_query_re = re.compile('(?:\(LONG\) )?Q: (?P<pg_op>[A-Z]+) (?P<pg_table>[^ ]+) .*: (?P<pg_status>completed|failed) at (?P<pg_state>master|slave) (?P<pg_host>[^\/]+)(?P<pg_db>[^,;]+)(?:, rc=0)?; took (?P<pg_took>\d+.\d+)$')

pg_query_re = re.compile('(?:\(LONG\) )?Q: (?P<pg_op>[A-Z]+) .*: (?P<pg_status>completed|failed) at (?P<pg_state>master|slave) (?P<pg_host>[^\/]+)\/(?P<pg_db>[^,;]+)(?:, rc=(?P<pg_rc>\d+))?; took (?P<pg_took>\d+.\d+)')


for line in sys.stdin:
    if line.strip() == '':
        continue

    parts = line.strip("\n").split("\t")
    parsed = {};
    for part in parts:
        eq = part.find('=')
        key = part[:eq]
        value = part[(eq+1):]
        parsed[key] = value        
    level = parsed['level']
    message = parsed['message']

    if parsed['class'] == 'r.y.ch.jdbc.q':
        pg_query_matches = pg_query_re.search(message)
        if pg_query_matches:
            pg_op = pg_query_matches.group('pg_op').lower()
            pg_status = pg_query_matches.group('pg_status')
            pg_took = pg_query_matches.group('pg_took')

            meter = pg_op
            # result_count_table_pg_op_status[pg_table][pg_op][pg_status] += 1
            results_timings_pg_op[meter].append(pg_took)

            if pg_status not in results_count_pg_op_status[meter]:
                results_count_pg_op_status[meter][pg_status] = 0 

            results_count_pg_op_status[meter][pg_status] += 1 # calc total
 

            if pg_op == 'select': # mb inaccuracy
                pg_op_type = 'aggr_read'
            else:
                pg_op_type =  'aggr_write'
   
            for meter in [pg_op_type, 'total']:
                results_timings_aggr_pg_op[meter].append(pg_took)

                if pg_status not in results_count_aggr_pg_op_status[meter]:
                    results_count_aggr_pg_op_status[meter][pg_status] = 0 

                results_count_aggr_pg_op_status[meter][pg_status] += 1 # calc total
   



for meter, values in sorted(results_count_pg_op_status.items()):
    for value_k, value_v in sorted (values.items()):
        print ("queller_count_pg_op_%s_%s %d" % (meter, value_k, value_v))


for meter, timings in sorted(results_timings_pg_op.items()):
    if len(timings):
        print("queller_timings_pg_op_%s %s" % (meter, ' '.join(timings) ))


for meter, values in sorted(results_count_aggr_pg_op_status.items()):
    for value_k, value_v in sorted (values.items()):
        print ("queller_count_aggr_pg_op_%s_%s %d" % (meter, value_k, value_v))


for meter, timings in sorted(results_timings_aggr_pg_op.items()):
    if len(timings):
        print("queller_timings_aggr_pg_op_%s %s" % (meter, ' '.join(timings) ))




 
