FROM registry.yandex.net/disk/clusters/disk-teamcity-agent:9540032

# Add postgresql repo for apt
RUN echo $'deb http://dist.yandex.ru/yandex-postgresql stable/$(ARCH)/\ndeb http://dist.yandex.ru/yandex-postgresql stable/all/\n' > /etc/apt/sources.list.d/yandex.postgresql-stable.list

RUN ulimit -n 102400; apt-get update && \
    apt-get install -y --force-yes \
        repo-verstka-stable=0.2 \
    && apt-get update && \
    apt-get install -y --force-yes \
        emacs \
        emacs24-nox \
        zip \
        # packages build dependencies
        gnupg-agent \
        libjs-jquery \
        # mpfs dependencies (to run tests)
        libauth-client-parser-python=1.16 \
        libauth-client-parser=1.16 \
        libticket-parser-python=0.1.33 \
        libticket-parser2-python=2.2.0 \
        libticket-parser=0.1.34 \
        mongodb-shell=1:3.0.11-yandex1 \
        postgresql-client \
        postgresql-client-common \
        python-all=2.7.5-5ubuntu3 \
        python-bson=2.6.3-yandex1 \
        python-celery=3.1.19-yandex2 \
        python-central \
        python-cjson=1.0.5-4build1 \
        python-click=6.7-yandex1 \
        python-crypto=2.6.1-yandex1 \
        python-cyson=1.10.1-4-ge5cf9c6 \
        python-dateutil=1.5+dfsg-1ubuntu1 \
        python-demjson=1.6-2build1 \
        python-dev=2.7.5-5ubuntu3 \
        python-django-crispy-forms=1.6.1-4 \
        python-kazoo=2.6.1-yandex1 \
        python-django-idm-api=2.4 \
        python-django-yauth=3.54 \
        python-blackbox=0.51 \
        python-enum34=1.0-yandex0 \
        python-flask=0.10.1-yandex2 \
        python-flup \
        python-gevent=1.0-1ubuntu1.1 \
        python-jinja2=2.7.3-yandex3 \
        python-keyczar=0.6~b.061709+svn502-1 \
        python-kombu=3.0.32-yandex1 \
        python-lxml=3.3.3-1ubuntu0.2 \
        python-markdown=2.4-1 \
        python-metrikatraficsource-bindings=0.9.0 \
        python-protobuf=2.5.0-9ubuntu1 \
        python-psycopg2=2.4.5-1build5 \
        python-pyasn1=0.1.7-1ubuntu2 \
        python-pymongo=2.6.3-yandex1 \
        python-requests=2.10.0-yandex1 \
        python-setuptools \
        python-signurl-bindings=0.2.0 \
        python-simplejson=3.3.1-1ubuntu6 \
        python-sqlalchemy=1.0.10-yandex1 \
        python-statbox-bindings2=0.23.0 \
        python-tdigest-bindings=0.1.2 \
        python-ujson=1.33-yandex2 \
        python-werkzeug=0.8.3-yandex1 \
        python-yaml=3.10-4ubuntu0.1 \
        python-ylog-lib=0.38 \
        python-ylog=0.38 \
        uatraits-data \
        uatraits-python \
        verstka-disk-emails=9.2 \
        yadisk-uwsgi \
        yandex-environment-development \
        yandex-yt-python=0.8.38-0 \
        ylog-rsyslog-conf=0.38 \
        python-jwt=1.3.0-1ubuntu0.1 \
        # java building deps
        maven \
        protobuf-compiler \
        # deploy deps
        conductor-utils \
        qloud-deploy=0.14.18 \
        # local postgres for MPFS tests
        postgresql-9.6 \
        postgresql-contrib-9.6 \
        # deps for pgmigrate
        postgresql-server-dev-9.6 \
        libpq-dev=9.6.9-1yandex.41743.1545ca9 \
        libpq5=9.6.9-1yandex.41743.1545ca9 \
        python-ndg-httpsclient \
        python-openssl \
        python-pyasn1 \
    && apt-get clean && rm -rf /var/lib/apt/lists/*

RUN pip install \
        importlib-metadata==0.23 \
        cryptography==2.8 \
        ansible==2.8.6 \
        attrdict==2.0.1 \
        before-after \
        configparser==3.5.0 \
        urllib3==1.25.7 \
        coverage==4.5.4 \
        enum34 \
        funcsigs \
        jsonschema==3.2.0 \
        matchers \
        mock==3.0.5 \
        more-itertools==4.3.0 \
        nose-parameterized==0.6.0 \
        pyhamcrest==1.9.0 \
        pyopenssl \
        pytest-cov==2.12.1 \
        pytest-django==3.7.0 \
        pytest-forked==1.0.2 \
        pytest-pythonpath \
        pytest-rerunfailures==4.2 \
        pytest-timeout==1.3.2 \
        pytest-xdist==1.26.1 \
        pytest==3.7.3 \
        pluggy==0.13.1 \
        pyrsistent==0.15.6 \
        sqlparse==0.2.4 \
        reimport \
        requests \
        wheel \
        zipp==0.6.0 \
        mongomock==3.10.0 \
        startrek_client \
        contextlib2==0.6.0.post1 \
        PyYAML==5.4.1 \
        psycopg2==2.6.2 \
        yandex-pgmigrate==1.0.3 \
        tankapi-client==1.10.0

#TODO: get rid of this dependency
RUN pip install pbr

ENV SONAR_DIR=/opt/sonar
RUN wget -q --output-document=sonar.zip \
    https://binaries.sonarsource.com/Distribution/sonar-scanner-cli/sonar-scanner-2.8.zip && \
    unzip -qq sonar.zip -d $SONAR_DIR && \
    rm -rf sonar.zip && \
    chmod u+x ${SONAR_DIR}/sonar-scanner-2.8/bin/sonar-scanner

# Copy common-settings
ADD common-settings/ /
