#!/bin/bash
set -e

# Pass qloud environmnet variables to cron job
. /root/.mpfs_pg_env

[[ -z "${MPFS_PG_NUM_COUNT+a}" ]] && exit 1

# Check: are all pg processes ready?
for ((i=0; i < $MPFS_PG_NUM_COUNT; i++)); do
    PORT=$(printf "120%02d" $i)
    pg_isready -q -p $PORT || exit 0
done

# If everything is ready - initialize MPFS tables
for ((i=0; i < $MPFS_PG_NUM_COUNT; i++)); do
    PORT=$(printf "120%02d" $i)

    # Create all users
    sudo -u postgres psql postgres -p $PORT -f /etc/yandex/mpfs/pg/init.sql
    
    for dbname in diskdb disk_commondb; do
        cd /etc/yandex/mpfs/pg/${dbname}
        LAST_VERSION=$(ls migrations | tail -1 | sed 's/__.*//g' | sed 's/V0*//g')
        # Apply migrations
        pgmigrate -t $LAST_VERSION \
            -c "host='localhost' port=$PORT dbname='${dbname}01' user='disk_mpfs' password='diskpasswd'" \
            -a afterAll:code,afterAll:grants \
            migrate
    done
done

# Reinstall psycopg2 with correct version (works for pgmigrate)
pip uninstall -y psycopg2
apt-get update && \
    apt-get install --reinstall -y --force-yes \
        python-psycopg2=2.4.5-1build5 && \
    apt-get clean && rm -rf /var/lib/apt/lists/*

# Remove cron job
rm /etc/cron.d/init-pg
