FROM registry.yandex.net/disk/common/trusty:latest

ENV BASE_PATH=/opt
ENV AGENT_HOME=$BASE_PATH/buildagent
ENV YANDEX_BUILD=$BASE_PATH/yandex-build

RUN ulimit -n 102400; apt-get update && \
    apt-get install -y --force-yes \
        unzip \
        # dev tools
        ant=1.9.3-2build1 \
        build-essential \
        dupload \
        devscripts \
        cdbs \
        debhelper \
        fakeroot \
        gcc \
        git \
        ipython \
        jq \
        mercurial \
        python-all \
        python-pip \
        python-yaml \
        subversion \
        yandex-dh-noconffiles \
        yandex-dh-environment \
        yandex-environment-development \
        s3cmd \
        # ssh and gpg keys
        sendmail \
    && apt-get clean && rm -rf /var/lib/apt/lists/* \
    && pip install -U \
        flake8 \
    && wget -q --output-document=buildagent.zip https://teamcity.yandex-team.ru/update/buildAgent.zip && \
       unzip -qq buildagent.zip -d $AGENT_HOME && \
       rm -rf buildagent.zip && \
       chmod u+x ${AGENT_HOME}/bin/*.sh

# Copy common-settings
ADD common-settings/ /

CMD ["/usr/sbin/disk-init"]
