#!/bin/bash

SPLITTED_STRINGS=$1
if [ ! -z $SPLITTED_STRINGS ]; then
    SEP='\n'
else
    SEP=';'
fi

result=$(\
    supervisorctl status | grep -v backend 2>/dev/null | \
    awk -v sep="$SEP" '$2!="RUNNING" {
            r[++counter]=$1"="$2
        }
        END {
            if (counter>0) {
                res="";
                for (i in r) res=res sep r[i];
                print "2" res;
            } else {
                print "0"sep"OK"
            }
        }'\
)

echo -e "$result"
