#!/bin/bash
set -e

S3_CFG=/etc/yandex/s3cmd.cdn.config
S3_CMD="s3cmd -c ${S3_CFG} put"
S3_BUCKET="disk-updates"
AUTHORIZED_USERS=("sponkratov" "ivanov-d-s" "shchepilov" "sammy" "veinarr" "farit" "bugrinov")

usage="Usage: $(basename "$0") (stable|beta|alpha) <path to local file> -- set build type and specify local path to binary file. Set \$TRIGGERED_BY_USER env variable before run."

build=$1
filepath=$2

function die {
        echo -e "$@"
        echo "$usage"
        exit 1
}

[[ "$#" -ne 2 ]] && die "Two arguments are required."
[[ $build =~ ^(stable|beta|alpha)$ ]] || die "build should be one of stable|beta|alpha."
[[ -f "$filepath" ]] || die "$filepath does not exist. Please specify correct path."
# check TC user
[[ -n "$TRIGGERED_BY_USER" ]] && [[ "${AUTHORIZED_USERS[@]} " =~ "$TRIGGERED_BY_USER " ]] || die "User ${TRIGGERED_BY_USERNAME} is not authorized to run CDN upload script"

md5=$(md5sum "$filepath"| cut -f 1 -d " ")
filename=$(basename "$filepath")
s3_prefix="${build}/${md5}"
cdn_url="https://disk.cdn.yandex.net/update/${build}/${md5}/${filename}"

$S3_CMD "${filepath}" "s3://${S3_BUCKET}/${s3_prefix}/"  || die "S3 upload failed."

echo "File ${filename} with md5 ${md5} CDN url: ${cdn_url}"

