#!/usr/bin/env python
# -*- coding: UTF-8 -*-
import sys
from collections import Counter


def tskv_get_key(line, key):
    key_index = line.find('\t%s=' % key)
    return line[key_index + (len(key)+2):].split('\t')[0]


def json_get_key(obj, key):
    key_index = obj.find('\\"%s\\":' % key)
    return obj[key_index + (len(key)+5) + 2:].split('\\')[0]


def metric_name(*args):
    return '_'.join(map(str, args))


app_prefix = 'Yandex.Disk '
app_platforms = {'android', 'ios'}
app_count_codes = Counter()

for line in sys.stdin:
    parts = line.strip()
    if not line:
        continue

    u_status = tskv_get_key(line, 'status')
    a_status = u_status[0] + 'xx'
    user_agent = tskv_get_key(line, 'user_agent')
    if not user_agent.startswith(app_prefix):
        continue
    user_agent_info = user_agent[len(app_prefix):]
    os = json_get_key(user_agent_info, 'os').split()[0].lower()
    if os not in app_platforms:
        continue
    vsn = json_get_key(user_agent_info, 'vsn')
    version = metric_name(os, vsn)
    app_count_codes[metric_name(version, u_status)] += 1
    app_count_codes[metric_name(version, a_status)] += 1


for key, value in sorted(app_count_codes.items()):
    print("%s %d" % (key, value))
