#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import re
import sys
from collections import Counter, defaultdict

results_count_type = Counter()
results_timings_type = defaultdict(list)

request_re = re.compile('^/api/databases/type_(\d+)/diffs')

for line in sys.stdin:
    if line.strip() == '':
        continue

    parts = line.strip("\n").split("\t")
    parsed = {}
    for part in parts:
        eq_index = part.find('=')
        key = part[:eq_index]
        value = part[(eq_index + 1):]
        parsed[key] = value

    request = parsed['request']
    request_time = parsed['request_time']
    request_matches = request_re.match(request)
    if not request_matches:
      continue

    t = int(request_matches.group(1))

    results_count_type[t] += 1
    results_timings_type[t].append(request_time)

for t, count in sorted(results_count_type.iteritems()):
    if count:
        print("query_count_type_{} {}".format(t, count))


for t, timings in sorted(results_timings_type.iteritems()):
    if timings:
        print("query_timings_type_{} {}".format(t, ' '.join(timings)))
