#!/usr/bin/env python

# -*- coding: UTF-8 -*-

import re
import sys
from collections import defaultdict, Counter

hosts_by_action = defaultdict(Counter)
shard_id_re = re.compile('shardId=(?P<shard_id>\w+)')
log_message_to_request_type = {
    'For getting conference': 'get_conference',
    'Register conference': 'create_conference',
    'Update conference': 'update_conference',
    'For new conference': 'new_conference',
    'For getting user': 'get_user'
}


def parse_tskv_field(tskv, field_name):
    field = '\t' + field_name + '='
    index = tskv.find(field)
    return tskv[index + len(field):].split('\t')[0]


def metric_name(*args):
    return '_'.join(map(str, args))


def print_shard_info(counter):
    for k, v in counter.items():
        for shard_id, value in v.items():
            print("%s_%s %d" % (k, shard_id, value))


lines = sys.stdin
for line in lines:
    if not line.strip():
        continue

    class_field = parse_tskv_field(line, 'class')
    message = parse_tskv_field(line, 'message')
    if class_field and 'tcm.actions.ConferenceActions' in class_field and message:
        matches = shard_id_re.search(message)

        if matches:
            shard_id = matches.group('shard_id')

            for log_message, yasm_metric in log_message_to_request_type.items():
                if log_message in message:
                    hosts_by_action[yasm_metric]['shard_' + shard_id] += 1

print_shard_info(hosts_by_action)
