#!/usr/bin/env python
# -*- coding: UTF-8 -*-
import sys
from collections import Counter


counter = Counter()


def tskv_get_key(line, key):
    key_index = line.find('\t%s=' % key)
    return line[key_index + (len(key)+2):].split('\t')[0]


def metric_name(*args):
    return '_'.join(map(str, args))


for line in sys.stdin:
    parts = line.strip()
    if not line:
        continue

    message_level = tskv_get_key(line, 'level')
    counter[metric_name('logmessage', message_level)] += 1

    message_class = tskv_get_key(line, 'class')
    counter[metric_name(message_class, message_level)] += 1


for key, value in sorted(counter.items()):
    print("%s %d" % (key, value))
