#!/usr/bin/env python2

import json
import sys

dmmm_keys = (
    'total',
    'buckets',
    'receiver_queue',
    'sender_queue',
)

def convert(d, prefix="from_json"):
    res = []
    for k, v in d.items():
        if type(v) in (int, float, bool):
            if type(v) == bool:
                v = int(v)
            suffix = 'tmmv'
            for key in dmmm_keys:
                if key in k or key in prefix:
                    suffix = 'dmmm'
                    break
            yasm_name = "%s_%s_%s" % (prefix, k, suffix)
            yasm_name = yasm_name \
                .replace(' ', '_') \
                .replace('<=', '_le_') \
                .replace('>', '_gt_')
            res.append([yasm_name, v])
        if type(v) == dict:
            res.extend(convert(v, '%s_%s' % (prefix, k)))
    return res

if __name__ == '__main__':
    s = sys.stdin
    d = json.load(s)
    prefix = "from_json"
    if len(sys.argv) > 1:
        prefix = sys.argv[1]
    res = convert(d, prefix)
    print(json.dumps(res))
