#!/bin/bash

# This is default plugin for selfdns-client.
# it chooses ipv4 and ipv6 addresses (if available) from default route to selfdns-api.yandex.net
#    as A/AAAA addresses for current host (PTR will added on api call).

# host, which will be used below to determine default route src addresses
ROUTE_HOST="dns-api.yandex.net"

V4_ROUTE_HOST="$(dig -t A +short "${ROUTE_HOST}" | head -1 | grep -Eo "([[:digit:]]{1,3}[.]){3}[[:digit:]]{1,3}")"
V6_ROUTE_HOST="$(dig -t AAAA +short "${ROUTE_HOST}" | head -1 | grep -Eo "[0-9a-f]{1,4}:[0-9a-f]{1,4}.*")"

if [ -z "${V4_ROUTE_HOST}" ] ; then
    echo 1>&2 "Cannot find V4_ROUTE_HOST, probably resolv.conf broken";
else
    IPV4_ADDRESS="$(/sbin/ip 2>/dev/null route get "${V4_ROUTE_HOST}" | awk '/ src / {for(i=1;i<=NF;i++)if($i~/src/)print $(i+1)}')"
fi

if [ -z "${V6_ROUTE_HOST}" ] ; then
    echo 1>&2 "Cannot find V6_ROUTE_HOST, probably resolv.conf broken";
else
    IPV6_ADDRESS="$(/sbin/ip 2>/dev/null route get "${V6_ROUTE_HOST}" | awk '/ src / {for(i=1;i<=NF;i++)if($i~/src/)print $(i+1)}')"
fi

if [ -z "$IPV4_ADDRESS" ] ; then
    echo "IPV4 address empty"
    exit 1
fi

if [ -z "$IPV6_ADDRESS" ] ; then
    echo "IPV6 address empty"
    exit 1
fi

export IPV4_ADDRESS
export IPV6_ADDRESS

. /config/jvb/discovery.env
python /usr/sbin/discovery.py
