#!/bin/bash

# Restart only 1/n hosts per day
restart_parts=3

# Restart host based on his hostname + day
utc_day=$(( `date +'%s'` / 86400 ))
host_hash=$(hostname | md5sum | awk '{print $1}')
host_dec=$((0x${host_hash}))
seed=$(( host_dec + utc_day ))

supervisorctl status backend | grep STOPPED && exit 0

if ! (( seed % restart_parts )); then
	maintenance close &&
	sleep 10 &&
	supervisorctl restart backend &&
	maintenance open
else
	echo "restart doesn't required";
fi
