FROM registry.yandex.net/disk/common/telemost:latest

env DEBIAN_FRONTEND=noninteractive

RUN apt-get update && \
    apt-get install -y \
	lua-sec \
	lua-cjson \
	luarocks \
	prosody=0.11.13-1~bionic1 \
	lua-expat \
	lua-filesystem \
	python3-pip \
	python3-setuptools \
	python3-wheel \
	ssl-cert && \
    apt-get install -y \
	jitsi-meet-web \
	jicofo=1.0-549-1 \
    patch \
    && apt-get -d install -y jitsi-meet-web-config && \
    dpkg -x /var/cache/apt/archives/jitsi-meet-web-config*.deb /tmp/pkg && \
    mkdir -p /defaults/web && \
    mv /tmp/pkg/usr/share/jitsi-meet-web-config/config.js /defaults/web && \
    rm -f /etc/nginx/conf.d/default.conf && \
    rm -rf /tmp/pkg /var/cache/apt && \
    apt-get clean && rm -rf /var/lib/apt-get/lists/*

RUN \
    apt-get -d install -y jitsi-meet-prosody && \
    dpkg -x /var/cache/apt/archives/jitsi-meet-prosody*.deb /tmp/pkg && \
    mv /tmp/pkg/usr/share/jitsi-meet/prosody-plugins /prosody-plugins && \
    rm -rf /tmp/pkg /var/cache/apt

RUN pip3 install xmpppy==0.6.1

RUN patch -d /usr/lib/prosody/modules/muc -p0 < /prosody-plugins/muc_owner_allow_kick.patch
env TZ=Europe/Moscow

ADD common-settings/ /
RUN patch -d /usr/lib/prosody/core -p0 < /prosody-plugins-custom/loggingmanager.lua.patch
