admins = { "focus@auth.$XMPP_DOMAIN", "jvb@auth.$XMPP_DOMAIN" }
plugin_paths = { "/prosody-plugins/", "/prosody-plugins-custom" }
http_default_host = "$XMPP_DOMAIN"

consider_websocket_secure = true
cross_domain_websocket = true

muc_mapper_domain_base = "$XMPP_DOMAIN"

muc_max_occupants = $MUC_USER_LIMIT
muc_access_whitelist = { "$AUTH_USER_UNLIM", "auth.$XMPP_DOMAIN" }

VirtualHost "$XMPP_DOMAIN"
    authentication = "$XMPP_AUTH_TYPE"
    ssl = {
        key = "/config/prosody/certs/$XMPP_DOMAIN.key";
        certificate = "/config/prosody/certs/$XMPP_DOMAIN.crt";
    }

    modules_enabled = {
        "measure_cpu";
        "measure_memory";
        "measure_stanza_counts";
        "http";
        "http_ping";
        "unistat";
        "bosh";
        "websocket";
        "pubsub";
        "ping";
        --"speakerstats";
        "rtcturn";
        "conference_duration";
        "muc_allowners";
    }

    --speakerstats_component = "speakerstats.$XMPP_DOMAIN"
    conference_duration_component = "conferenceduration.$XMPP_DOMAIN"
    c2s_require_encryption = false

VirtualHost "auth.$XMPP_DOMAIN"
    ssl = {
        key = "/config/prosody/certs/$XMPP_AUTH_DOMAIN.key";
        certificate = "/config/prosody/certs/$XMPP_AUTH_DOMAIN.crt";
    }
    authentication = "internal_plain"

Component "internal.auth.$XMPP_DOMAIN" "muc"
    modules_enabled = {
        "ping";
    }
    storage = "memory"
    muc_room_cache_size = 1000

Component "conference.$XMPP_DOMAIN" "muc"
    storage = "memory"
    modules_enabled = {
        "muc_meeting_id";
        "muc_domain_mapper";
        "muc_yandex_max_occupants";
        "measure_muc";
    }
    muc_room_locking = false
    muc_room_default_public_jids = true

Component "focus.$XMPP_DOMAIN"
    component_secret = "$JICOFO_COMPONENT_SECRET"

--TELEMOST-343
--Component "speakerstats.$XMPP_DOMAIN" "speakerstats_component"
--    muc_component = "conference.$XMPP_DOMAIN"

Component "conferenceduration.$XMPP_DOMAIN" "conference_duration_component"
    muc_component = "conference.$XMPP_DOMAIN"
