local st = require "util.stanza";
prosody.unlock_globals()
local https = require "ssl.https"
https.TIMEOUT = 1
local ltn12 = require "ltn12"
prosody.lock_globals()
local cjson = require "cjson"

local url = "$TURN_CONFIG_URL"

function tableHasKey(table, key)
    return table[key] ~= nil
end

function split(s, delimiter)
    local result = {};
    for match in (s .. delimiter):gmatch("(.-)" .. delimiter) do
        table.insert(result, match);
    end
    return result;
end

function getCredential()
    local resp = {}
    local body, code, headers, status = https.request {
        url = url,
        sink = ltn12.sink.table(resp)
    }

    if code ~= 200 then
        return nil
    end

    local json = cjson.decode(table.concat(resp))

    if tableHasKey(json, "ice_servers") then
        local servers = json["ice_servers"]
        if servers ~= nil then
            local server = servers[1]
            local urls = {}
            local r = {}
            for idx, turn_url in pairs(server["urls"]) do
                local splitted = split(turn_url, ":")
                if #splitted ~= 3 then
                    return
                end
                local port_part = split(splitted[3], "?")
                if #port_part ~= 2 then
                    return
                end
                local transport_part = split(port_part[2], "=")
                if #transport_part ~= 2 then
                    return
                end
                local turn = {}
                turn["type"] = splitted[1]
                turn["address"] = splitted[2]
                turn["port"] = port_part[1]
                turn["transport"] = transport_part[2]
                table.insert(urls, turn)
            end
            r["urls"] = urls
            r["username"] = server["username"]
            r["credential"] = server["credential"]
            r["ttl"] = json["ice_servers_ttl"]
            return r
        else
            return nil
        end
    else
        return nil
    end
end

module:hook("iq-get/host/urn:xmpp:extdisco:1:services", function(event)
    local origin, stanza = event.origin, event.stanza;
    if origin.type ~= "c2s" then
        return;
    end
    local cred = getCredential()
    if cred == nil then
        module:log("error", "rtc return nil")
        return
    end
    local urls = cred["urls"]
    local reply = st.reply(stanza):tag("services", { xmlns = "urn:xmpp:extdisco:1" })
    for idx, item in pairs(urls) do
        local turn = {}
        -- turn items need host, port (defaults to 3478),
        -- transport (defaults to udp)
        -- username, password, ttl
        turn.type = item["type"];
        turn.port = item["port"];
        turn.transport = item["transport"];
        turn.username = cred["username"];
        turn.password = cred["credential"];
        turn.ttl = tostring(cred["ttl"]);
        turn.host = item["address"]
        reply:tag("service", turn):up();
    end
    origin.send(reply);
    return true;
end);
