-- MUC Max Occupants
-- Configuring muc_max_occupants will set a limit of the maximum number
-- of participants that will be able to join in a room.
-- Participants in muc_access_whitelist will not be counted for the
-- max occupants value (values are jids like recorder@jitsi.meeet.example.com).
-- This module is configured under the muc component that is used for jitsi-meet
local split_jid = require "util.jid".split;
local st = require "util.stanza";
local it = require "util.iterators";

local whitelist = module:get_option_set("muc_access_whitelist");
local MAX_OCCUPANTS = module:get_option_number("muc_max_occupants", 12);

local function count_keys(t)
  return it.count(it.keys(t));
end

local function check_for_max_occupants(event)
  local room, origin, stanza = event.room, event.origin, event.stanza;

	local actor = stanza.attr.from;
  local user, domain, res = split_jid(stanza.attr.from);

  --no user object means no way to check for max occupants
  if user == nil then
    return
  end

  -- If we're a whitelisted user joining the room, don't bother checking the max
  -- occupants.
  if whitelist and whitelist:contains(domain) or whitelist:contains(user..'@'..domain) or whitelist:contains(user) then
    return;
  end

  if user == 'staff' then
    MAX_OCCUPANTS = 35;
  end

	if room and not room._jid_nick[stanza.attr.from] then
		local count = count_keys(room._occupants);
		local slots = MAX_OCCUPANTS;

		-- If there is no whitelist, just check the count.
		if count >= MAX_OCCUPANTS then
			module:log("info", "Attempt to enter a maxed out MUC");
			origin.send(st.error_reply(stanza, "cancel", "service-unavailable"));
			return true;
		end
	end
end

module:hook("muc-occupant-pre-join", check_for_max_occupants, 10);
