-- Log statistics to unistat
--

module:set_global();

local cjson = require "cjson"
local t_insert = table.insert;
local statsman = require "core.statsmanager";

local function get_metrics(event)
	local response = event.response;
	response.headers.content_type = "application/json; version=0.0.1";
	local stats, _, extra = statsman.get_stats();
	local metrics = {};
	for stat, value in pairs(stats) do
	    local name = string.gsub(string.gsub(stat, "*", "ALL"), ":", "-") .. "_tmmv"
	    local metric = {name, value}
	    t_insert(metrics, metric)
	end
	return cjson.encode(metrics);
end

function module.add_host(module)
	module:depends "http";
	module:provides("http", {
		default_path = "metrics";
		route = {
			GET = get_metrics;
		};
	});
end
