#!/usr/bin/env python
# -*- coding: UTF-8 -*-
import json
import sys
from collections import Counter

counter = Counter()

def tskv_get_key(line, key):
    key_index = line.find('\t%s=' % key)
    return line[key_index + (len(key)+2):].split('\t')[0]

def metric_name(*args):
    return '_'.join(map(str, args))

for line in sys.stdin:
    if not line:
        continue
    try:
        log = json.loads(line.strip())
    except:
        continue

    level = log['level']
    source = log['source']
    if level != 'info':
        msg = '{}_{}'.format(level, source)
        counter[msg] += 1
    counter[level] += 1

for key, value in sorted(counter.items()):
    print("%s %d" % (key, value))
