FROM registry.yandex.net/disk/common/telemost:latest

env DEBIAN_FRONTEND=noninteractive

RUN apt-get update && \
    apt-get install -y \
	lua-sec \
	luarocks \
	prosody=0.11.6-1~bionic1 \
	lua-expat \
	lua-filesystem \
	ssl-cert && \
    apt-get install -y \
	jitsi-meet-web \
	jicofo=1.0-549-1 \
    patch \
	jitsi-videobridge2=2.1-183-gdbddd169-1 && \
    apt-get -d install -y jitsi-meet-web-config && \
    dpkg -x /var/cache/apt/archives/jitsi-meet-web-config*.deb /tmp/pkg && \
    mkdir -p /defaults/web && \
    mv /tmp/pkg/usr/share/jitsi-meet-web-config/config.js /defaults/web && \
    rm -f /etc/nginx/conf.d/default.conf && \
    rm -rf /tmp/pkg /var/cache/apt && \
    apt-get clean && rm -rf /var/lib/apt-get/lists/*

RUN \
    apt-get -d install -y jitsi-meet-prosody && \
    dpkg -x /var/cache/apt/archives/jitsi-meet-prosody*.deb /tmp/pkg && \
    mv /tmp/pkg/usr/share/jitsi-meet/prosody-plugins /prosody-plugins && \
    rm -rf /tmp/pkg /var/cache/apt

RUN patch -d /usr/lib/prosody/modules/muc -p0 < /prosody-plugins/muc_owner_allow_kick.patch

ADD common-settings/ /
