admins = { "focus@auth.$XMPP_DOMAIN", "jvb@auth.$XMPP_DOMAIN" }
plugin_paths = { "/prosody-plugins/", "/prosody-plugins-custom" }
http_default_host = "$XMPP_DOMAIN"

muc_mapper_domain_base = "$XMPP_DOMAIN"

VirtualHost "$XMPP_DOMAIN"
    authentication = "internal_plain"
    ssl = {
        key = "/config/prosody/certs/$XMPP_DOMAIN.key";
        certificate = "/config/prosody/certs/$XMPP_DOMAIN.crt";
    }
    modules_enabled = {
        "bosh";
        "pubsub";
        "ping";
        "speakerstats";
        --"turncredentials";
        "conference_duration";
    }

    c2s_require_encryption = false

VirtualHost "auth.$XMPP_DOMAIN"
    ssl = {
        key = "/config/prosody/certs/$XMPP_AUTH_DOMAIN.key";
        certificate = "/config/prosody/certs/$XMPP_AUTH_DOMAIN.crt";
    }
    authentication = "internal_plain"

Component "internal.auth.$XMPP_DOMAIN" "muc"
    modules_enabled = {
        "ping";
    }
    storage = "memory"
    muc_room_cache_size = 1000

Component "conference.$XMPP_DOMAIN" "muc"
    storage = "memory"
    modules_enabled = {
        "muc_meeting_id";
        "muc_domain_mapper";
    }
    muc_room_locking = false
    muc_room_default_public_jids = true

Component "focus.$XMPP_DOMAIN"
    component_secret = "$JICOFO_COMPONENT_SECRET"

Component "speakerstats.$XMPP_DOMAIN" "speakerstats_component"
    muc_component = "conference.$XMPP_DOMAIN"

Component "conferenceduration.$XMPP_DOMAIN" "conference_duration_component"
    muc_component = "conference.$XMPP_DOMAIN"
