FROM registry.yandex.net/disk/distro/bionic:latest
LABEL maintainer="disk-frontend@yandex-team.ru"

RUN apt-get update \
    && apt-get install -y --force-yes \
        abyssync=0.2-8408676 \
        gawk \
        nginx=1.14.2-1.yandex.93 \
        rsyslog=8.32.0-1ubuntu4 \
        uatraits-data=1.1.71-7 \
        yandex-disk-common-rsyslog=1.0-5 \
        yandex-lang-detect-data=1.2-38 \
        yandex-passport-vault-client=1.4.0 \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/* \
    && rm -f /etc/cron.d/p2p-distribution-* /etc/cron.d/yandex-gosky \
    && rm -rf /etc/monrun/* /etc/snaked/jobs/* /etc/yandex/environment* \
    && rm -f /etc/rsyslog.d/50-default.conf /etc/logrotate.d/rsyslog \
    && sed -i '/session    required     pam_loginuid.so/c#session    required   pam_loginuid.so' /etc/pam.d/cron

# Fix security bug: https://stackoverflow.com/questions/43323754/cannot-make-remove-an-entry-for-the-specified-session-cron


ADD common-settings/ /
ADD front-common-settings/ /
CMD ["/usr/sbin/disk-init"]
