#!/bin/bash

export LANGUAGE=en_US.UTF-8
export LC_ALL=en_US.UTF-8
export LANG=en_US.UTF-8
export LC_TYPE=en_US.UTF-8

parse_configured=false

grep_text=""

grep_access=true
grep_application=true
grep_event=true
grep_nginx=false

time_to_grep=600
verbose=false

log() {
    if [ $verbose = true ]; then
        echo "$1"
    fi
}

print_usage() {
    echo "Usage: ./grep_logs.sh OPTIONS {string_to_grep}"
    echo "    -q / --quiet"
    echo "    -v / --verbose"
    echo "    -d / --app / --tskv"
    echo "    -n / --nginx"
    echo "    -e / --event"
    echo "    --all - grep add logs"
    echo "    -t / --time {seconds to grep}"
}

clear_parse_config_if_not_set() {
    if [ $parse_configured = false ]; then
        parse_configured=true

        grep_access=false
        grep_application=false
        grep_event=false
        grep_nginx=false
    fi
}

while [[ $# -gt 0 ]]
do
    key="$1"

    case $key in
        -a|--access)
        clear_parse_config_if_not_set
        grep_access=true
        shift # past argument
    ;;
        -n|--nginx)
        clear_parse_config_if_not_set
        grep_nginx=true
        shift # past argument
    ;;
        -e|--event)
        clear_parse_config_if_not_set
        grep_event=true
        shift # past argument
    ;;
        --app|--tskv|-d)
        clear_parse_config_if_not_set
        grep_application=true
        shift # past argument
    ;;
        -q|--quiet)
        verbose=false
        shift # past argument
    ;;
        -v|--verbose)
        verbose=true
        shift # past argument
    ;;
        -all)
        clear_parse_config_if_not_set

        grep_access=true
        grep_application=true
        grep_event=true
        grep_nginx=true
        shift # past argument
    ;;
    -t|--time)
        time_to_grep="$2"
        shift # past argument
        shift # past value
    ;;
    *)
        grep_text="$key"
        shift
    ;;
esac
done

if [[ -z $grep_text ]]; then
    print_usage
    exit 1
fi

log "grep_access=$grep_access"
log "grep_application=$grep_application"
log "grep_event=$grep_event"
log "grep_nginx=$grep_nginx"
log "time_to_grep=$time_to_grep"
log "grep_text=$grep_text"

logs_home=""

if [ -d "/var/log/yandex/disk" ]; then
    logs_home="/var/log/yandex/disk";
elif [ -d "/var/log/yandex/dataapi" ]; then
    logs_home="/var/log/yandex/dataapi";
elif [ -d "/var/log/yandex/docviewer" ]; then
    logs_home="/var/log/yandex/docviewer";
elif [ -d "/var/log/yandex/axis" ]; then
    logs_home="/var/log/yandex/axis";
elif [ -d "/var/log/yandex/telemost" ]; then
    logs_home="/var/log/yandex/telemost";
else
    echo "Can't find logs dir in /var/log/yandex";
    exit 1
fi

log "logs_home=$logs_home"

if [ $grep_application = true ]; then
    log "---------------------------------------------------------------------------------------------------------"
    log "----                                      application                                                ----"
    log "---------------------------------------------------------------------------------------------------------"
    log_paths=$( ls $logs_home | fgrep -v "access" | fgrep -v events | grep "tskv.log$" )
    for log_path in $log_paths; do
        timetail -t java -n $time_to_grep "$logs_home/$log_path" | fgrep "$grep_text"
    done
fi

if [ $grep_event = true ]; then
    log "---------------------------------------------------------------------------------------------------------"
    log "----                                      events                                                     ----"
    log "---------------------------------------------------------------------------------------------------------"
    log_paths=$( ls $logs_home | grep "events-tskv.log$" )
    for log_path in $log_paths; do
        timetail -t java -n $time_to_grep "$logs_home/$log_path" | fgrep "$grep_text"
    done
fi

if [ $grep_access = true ]; then
    log "---------------------------------------------------------------------------------------------------------"
    log "----                                      java-access                                                ----"
    log "---------------------------------------------------------------------------------------------------------"
    log_paths=$( ls $logs_home | grep "access-tskv.log$" )
    for log_path in $log_paths; do
        timetail -t java -n $time_to_grep "$logs_home/$log_path" | fgrep "$grep_text"
    done
fi

if [ $grep_nginx = true ]; then
    log "---------------------------------------------------------------------------------------------------------"
    log "----                                      nginx-access                                               ----"
    log "---------------------------------------------------------------------------------------------------------"
    timetail -t tskv -n $time_to_grep "/var/log/nginx/access-tskv.log" | fgrep "$grep_text"
fi

exit 0
