#!/bin/sh

set -e

check_time="-1440"
hd_count_limit=3
hd_path=`ps axww -o command |  grep -v grep | grep -oP 'HeapDumpPath=[^ ]+' | cut -d'=' -f2 | sort | uniq`
r_code=0
r_message=""


if [ -z "${hd_path}" ] ; then
    r_message="${r_message} no processes with HeapDumpPath found"
    r_code=0
fi

for b_path in ${hd_path} ; do
    if [ -d "${b_path}" ] ; then
        path="${b_path}"
    else
        path=`dirname "${b_path}"`
    fi
    hd_count=`find "${path}" -maxdepth 1 -mmin "${check_time}" -name '*.hprof' -print | wc -l`
    r_message="${r_message} ${hd_count} in ${path},"
    if [ ${hd_count} -ge ${hd_count_limit} ]; then
        r_code=2 
    fi
done

echo "${r_code}; ${r_message}"
exit ${r_code}

