#!/bin/bash
PID=$(supervisorctl pid push-client)
[ -z "$PID" ] && echo "2;Push-client not running" && exit 1

COMMAND=$(ps --no-headers -w -o cmd $PID)
CONFIGS=( ${COMMAND#*-c } )
CONFIGS=${CONFIGS[@]#-c}

[ -z "$CONFIGS" ] && echo "2; Push-client not running" && exit 1

for i in $CONFIGS; do
    if ! pgrep -P $PID -f "push-client.* -c $i" > /dev/null; then
        echo "2; Push-client not running"
        exit 1
    fi

    # skip status checks for autogenerated configurations for private storage
    [[ $i == /var/lib/push-client/configs/space_* ]] && continue

    STATUS=$(push-client --check:commit-time=21600 --status -c $i 2>&1 | awk '/: status:/{print $NF}')
    case $STATUS in
        "ok") ;;
        "warn") echo "1; Push-client status is $STATUS"
              exit 1
              ;;
             *) echo "2; Push-client status is $STATUS"
              exit 1
              ;;

    esac
done

echo "0; OK"
exit 0
