#!/bin/bash

SERVICE_PORT=${1:-80}    
SERVICE_PING_CODE=`curl -m 3 -s -o /dev/null -I -w "%{http_code}" http://localhost:${SERVICE_PORT}/ping`
SERVICE_LOCK_FILE='/.nginx_service_locked.lock'
SERVICE_MANUAL_LOCK_FILE='/maintenance.lock'

if [ -f ${SERVICE_MANUAL_LOCK_FILE} ]; then
    # service was closed manually
    echo "2;Maintenance lock found. Service closed"
    exit 0
fi

if [ ${SERVICE_PING_CODE} -eq 200 ]; then
  # service online

  if [ -f ${SERVICE_LOCK_FILE} ]; then
    # opening port for traffic
    rm -f ${SERVICE_LOCK_FILE}
  fi
  echo "0;Serving requests"

else
  # service offline

  if [ ! -f ${SERVICE_LOCK_FILE} ]; then
    # closing port from traffic load
    touch -f ${SERVICE_LOCK_FILE}
  fi
  echo "2;/ping unreachable. Service port closed."
fi
