#!/usr/bin/env python
import json
import os


def get_geo_tags():
    datacenter = os.getenv(
        'QLOUD_DATACENTER',
        os.getenv('DEPLOY_NODE_DC', '')
    ).lower()
    if not datacenter:
        return []
    result = ['a_geo_%s' % datacenter]
    if datacenter in ['iva', 'myt']:
        result.append('a_geo_msk')
    return result


def get_geo_tags_from_file():
    datacenter = ''
    try:
        with open('/etc/qloud/meta.json', 'r') as meta_file:
            datacenter = json.load(meta_file)['datacenter'].lower()
    except Exception:
        try:
            with open('/pod_agent_public/human_readable_current_spec.json', 'r') as meta_file:
                datacenter = json.load(meta_file)['immutable_meta']['node_meta']['dc'].lower()
        except Exception:
            return []

    result = [str('a_geo_%s' % datacenter)]
    if datacenter in ['iva', 'myt']:
        result.append('a_geo_msk')
    return result


def format(events):
    for event in events:
        if 'tags' not in event:
            event['tags'] = []
        event['tags'].extend(set(get_geo_tags() + get_geo_tags_from_file()))
    return events
