#!/bin/bash

SERVICES="backend nginx $STOP_HOOK_SERVICES"
LAG_CHECK_CMD="push-client --status -c /etc/yandex/statbox-push-client/push-client-qloud-application.yaml --check:commit-time=1 --check:lag-size=1"
LAG_STATUS_CMD="${LAG_CHECK_CMD} --json  2>&1 | jq  -c -M '.[] | {lag,status,name}' | paste -s -d ' '"
BACKEND_PID=$(supervisorctl pid backend)
SLEEP_TIME_USR2=20
SLEEP_TIME_CLOSE=${STOP_HOOK_SLEEP_TIME_CLOSE:-35}
SLEEP_TIME_SERVICES_STOP=20
STOP_SCRIPTS_D="/etc/yandex/stop-scripts.d"


logit() {
    logger -t 'stop_hook' "${*}"
}

check_push-client_lag () {
  i=0

  while [ $i -lt "$1" ]; do
    logit "push-client lag status $(eval $LAG_STATUS_CMD)"
    logit "currently running  {$(ps -eo comm= | paste -s -d ' ')}"
    $LAG_CHECK_CMD >/dev/null 2>&1 && return 0
    sleep 10
    i=$((i+1))
  done

  return 1
}


# Closing from SLB
logit "close from balancer and sleeping ${SLEEP_TIME_CLOSE}s"
/usr/local/sbin/maintenance close
sleep $SLEEP_TIME_CLOSE


# Preparing java apps to stop with USR2 signal, if defined
if [[ "${STOP_HOOK_SEND_USR2:-0}" -eq 1 ]]; then
  logit "sending USR2 signal to pid $BACKEND_PID and sleeping ${SLEEP_TIME_USR2}s"
  kill -USR2 "$BACKEND_PID"
  sleep $SLEEP_TIME_USR2
else
  logit "sending USR2 signal is not configured"
fi


# Stopping services
logit "stopping supervisor services $SERVICES and sleeping ${SLEEP_TIME_SERVICES_STOP}s"
supervisorctl stop "$SERVICES"
sleep $SLEEP_TIME_SERVICES_STOP
logit "supervisor services status $(supervisorctl status | awk '{printf "{%s %s} ", $1,$2}')"
logit "currently running  {$(ps -eo comm= | paste -s -d ' ')}"


# Running optional  stop-scripts
logit "running scripts from $STOP_SCRIPTS_D"
run-parts $STOP_SCRIPTS_D


# Final stop section
if check_push-client_lag 10; then
  logit "push-client lag is OK, shutting down supervisor"
  supervisorctl shutdown
  exit 0
else
  logit "push-client lag check FAILED, restarting push-client"
  supervisorctl stop push-client && sleep 5 && supervisorctl start push-client
  sleep 15
  if check_push-client_lag 10; then
    logit "push-client lag is OK, shutting down supervisor"
    supervisorctl shutdown
    exit 0
  else
    logit "Something went wrong, exiting with error"
    exit 1
  fi
fi
