FROM registry.yandex.net/disk/common/bionic:latest
LABEL maintainer="disk-admin@yandex-team.ru"

RUN echo 'deb https://download.jitsi.org stable/' > /etc/apt/sources.list.d/jitsi-stable.list \
    && echo 'deb http://packages.prosody.im/debian bionic main' > /etc/apt/sources.list.d/prosody.list \
    && rm -f /etc/apt/apt.conf.d/01-dist-https \
    && wget -qO - https://prosody.im/files/prosody-debian-packages.key | apt-key add - \
    && wget -qO - https://download.jitsi.org/jitsi-key.gpg.key | apt-key add - \
    && apt-get update \
    && apt-get install -y --force-yes \
        getenvoy-envoy=1.14.1.p0.g3504d40-1p63.g902f20f.yandex0 \
        nginx=1.14.2-1.yandex.22 \
        yandex-openjdk11=11.0.3.shenandoah-tzdata2018g \
        libticket-parser \
        libshflags \
    && apt-get clean && rm -rf /var/lib/apt/lists/* \
    && rm -rf /etc/monrun/* /etc/snaked/jobs/* \
    && sed -i '/session    required     pam_loginuid.so/c#session    required   pam_loginuid.so' /etc/pam.d/cron

# Fix security bug: https://stackoverflow.com/questions/43323754/cannot-make-remove-an-entry-for-the-specified-session-cron

ADD common-settings/ /
