FROM registry.yandex.net/disk/distro/xenial:latest
LABEL maintainer="disk-frontend@yandex-team.ru"

RUN apt-get update && apt-get install -y --force-yes \
        abyssync=0.2-8408676 \
        gawk \
        geobase-checker4=6.0-10 \
        libgeobase5-nodejs=5.3-14 \
        libgeobase5=5.3-14 \
        libticket-parser2 \
        libticket-parser2-nodejs \
        libuatraits=1.2.2-12 \
        libyandex-lang-detect=1.6-56 \
        nodejs-8=8.9.0-1 \
        p2p-distribution-geobase-tzdata-config=1.0-24 \
        p2p-distribution-geodata4-config=1.0-24 \
        p2p-distribution=1.0-24 \
        p2p-distribution-ipreg-layout-config=1.0-24 \
        rsyslog=8.16.0-1ubuntu3.1 \
        uatraits-data=1.1.68-4 \
        uatraits-nodejs=1.2.2-12 \
        yandex-disk-common-rsyslog=1.0-5 \
        yandex-lang-detect-data=1.2-26 \
        yandex-lang-detect-nodejs=1.6-56 \
        yandex-passport-vault-client=1.4.0 \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/* \
    && rm -f /etc/cron.d/p2p-distribution-* /etc/cron.d/yandex-gosky \
    && rm -rf /etc/monrun/* /etc/snaked/jobs/* /etc/yandex/environment* \
    && rm -f /etc/rsyslog.d/50-default.conf /etc/logrotate.d/rsyslog \
    && sed -i '/session    required     pam_loginuid.so/c#session    required   pam_loginuid.so' /etc/pam.d/cron

# Fix security bug: https://stackoverflow.com/questions/43323754/cannot-make-remove-an-entry-for-the-specified-session-cron

ADD common-settings/ /
ADD front-common-settings/ /
CMD ["/usr/sbin/disk-init"]
