FROM registry.yandex.net/ubuntu:bionic
LABEL maintainer="disk-admin@yandex-team.ru"

ENV LANG=en_US.UTF-8
ENV DEBIAN_FRONTEND=noninteractive
USER root

RUN sed -i "s/archive.ubuntu.com/mirror.yandex.ru/g" /etc/apt/sources.list \
    && apt-get update -qq \
    && apt-get dist-upgrade --force-yes -y \
    && apt-get install --force-yes -y \
        curl \
        less \
        locales \
        nano \
        tmux \
        tzdata \
        vim \
        wget \
        yandex-archive-keyring \
        yandex-ca-certs \
        yandex-conf-repo-prestable \
        yandex-conf-repo-testing \
        yandex-conf-repo-unstable \
        yandex-internal-root-ca \
    && apt-get clean && rm -rf /var/lib/apt/lists/* \
    && locale-gen en_US.UTF-8 && update-locale LANG=en_US.UTF-8 \
    && echo "Europe/Moscow" > /etc/timezone && dpkg-reconfigure -f noninteractive tzdata \
    && apt-get update -qq \
    && apt-get install -y --force-yes \
        apt-utils \
    && apt-get update -qq \
    && apt-get install -y \
        yandex-disk-common-apt=1.0-65 \
        repo-search-stable \
    && apt-get remove --purge -y --force-yes \
        yandex-conf-repo-prestable \
        yandex-conf-repo-testing \
        yandex-conf-repo-unstable \
    && apt-get update -qq \
    && sed -i '2s/$/echo service disabled\nexit 0/' /usr/sbin/service \
    && sed -i '2s/$/\nprint STDERR "update-rc.d disabled";\nexit (0);/' /usr/sbin/update-rc.d \
    && apt-get install -y --force-yes \
        bash-completion \
        config-yandex-friendly-bash \
        corba-postfix-fixer \
        curl \
        file \
        getenvoy-envoy=1.14.1.p0.g3504d40-1p63.g902f20f.yandex0 \
        gettext \
        jq \
        juggler-client=2.3.2010131240 \
        juggler-client-core=2.3.2010131240 \
        libshflags \
        libticket-parser \
        loggiver \
        loggiver2yasmagent=0.1-7256202 \
        logrotate-hourly \
        logrotate=3.14.0-14-gfcb65b0-yandex \
        lsof \
        mc \
        supervisor \
        monrun=1.3.5 \
        net-tools \
        netcat-openbsd \
        nginx=1.14.2-1.yandex.22 \
        openssh-client \
        pigz \
        python-requests \
        python-yaml \
        rsync \
        strace \
        sudo \
        tcpdump \
        telnet \
        traceroute \
        updatedb-exclude-srv \
        vim-tiny \
        wget \
        yandex-archive-keyring \
        yandex-conf-hostname-long \
        yandex-dash2bash \
        yandex-jdk8 \
        yandex-juggler-http-check \
        yandex-locales \
        yandex-media-tskv-parser=1.0.3 \
        yandex-openjdk11=11.0.3.shenandoah-tzdata2018g \
        yandex-openjdk17=17.0.2-tzdata2021e \
        yandex-push-client=6.69.4 \
        yandex-timetail \
        yandex-watchdog \
    && apt-get clean && rm -rf /var/lib/apt/lists/* \
    && rm -f /etc/cron.d/ubic /etc/init.d/ubic-watchdog /etc/cron.d/juggler-client /etc/monrun/conf.d/* \
    && sed -i '/session    required     pam_loginuid.so/c#session    required   pam_loginuid.so' /etc/pam.d/cron

RUN apt-get update -qq \
    && apt-get install -y --force-yes \
        python-setuptools \
    && apt-get clean && rm -rf /var/lib/apt/lists/* \
    && echo -e "[global]\nindex-url = https://pypi.yandex-team.ru/simple/" > /etc/pip.conf ; chmod a+r /etc/pip.conf \
    && echo -e "[easy_install]\nindex_url = https://pypi.yandex-team.ru/simple/" > /usr/lib/python2.7/distutils/distutils.cfg \
    && echo -e "[easy_install]\nindex_url = https://pypi.yandex-team.ru/simple/" > /usr/lib/python3.6/distutils/distutils.cfg \
    && python /usr/lib/python2.7/dist-packages/easy_install.py -i https://pypi.yandex-team.ru/simple/ -U supervisor==4.2.1 && mkdir -p /var/log/supervisor

RUN    echo 'deb http://dist.yandex.ru/search-bionic/ stable/$(ARCH)/' >> /etc/apt/sources.list.d/search-bionic.list \
    && echo 'deb http://dist.yandex.ru/search-bionic/ stable/all/'     >> /etc/apt/sources.list.d/search-bionic.list \
    && apt-get update \
    && apt-get -y install \
        yandex-porto \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/* \
    && rm /etc/apt/sources.list.d/search-bionic.list

