import logging
import os
import time


def _master_internal():
    if os.path.exists('/etc/salt/minion_master_override'):
        with open('/etc/salt/minion_master_override', 'r') as master_override:
            return master_override.readline().rstrip('\n')
    return 'pg-salt.disk.in.yandex.net'


def master():
    for _ in range(3):
        try:
            return _master_internal()
        except Exception as exc:
            logging.error('Unable to get master: %s', repr(exc))
            time.sleep(1)


if __name__ == '__main__':
    print(master())
