#!/bin/bash

apt-get update
apt-get install -y \
    autoconf \
    automake \
    build-essential \
    build-essential \
    cdbs \
    cmake \
    debhelper \
    devscripts \
    dupload \
    fakeroot \
    gcc \
    git \
    git-core \
    ipython \
    jq \
    libass-dev \
    libfreetype6-dev \
    libnuma-dev \
    libssl-dev \
    libtheora-dev \
    libtool \
    libvorbis-dev \
    libvpx-dev \
    libx264-dev \
    libx265-dev \
    mercurial \
    nasm \
    pkg-config \
    python-all \
    python-pip \
    subversion \
    texinfo \
    wget \
    yandex-dh-environment \
    yandex-dh-noconffiles \
    yasm \
    zlib1g-dev

git clone -b release/4.3 https://git.ffmpeg.org/ffmpeg.git ffmpeg
cd ffmpeg
./configure \
    --arch=x86_64 \
    --cpu=generic \
    --disable-demuxer=applehttp \
    --disable-demuxer=concat \
    --disable-demuxer=dash \
    --disable-demuxer=ffm \
    --disable-demuxer=hls \
    --disable-demuxer=image2 \
    --disable-demuxer=live_flv \
    --disable-demuxer=msnwc_tcp \
    --disable-demuxer=rtp \
    --disable-demuxer=rtsp \
    --disable-demuxer=tedcaptions \
    --disable-demuxer=vapoursynth \
    --disable-demuxer=webm_dash_manifest \
    --disable-encoder=libschroedinger \
    --disable-ffplay \
    --disable-muxers \
    --enable-avfilter \
    --enable-avresample \
    --enable-filter=drawtext \
    --enable-gpl \
    --enable-libtheora \
    --enable-libvorbis \
    --enable-libx264 \
    --enable-muxer=adts \
    --enable-muxer=dash \
    --enable-muxer=hls \
    --enable-muxer=mov \
    --enable-muxer=mp4 \
    --enable-muxer=stream_segment \
    --enable-nonfree \
    --enable-openssl \
    --enable-postproc \
    --enable-runtime-cpudetect \
    --enable-version3 \
    --extra-ldexeflags="-static" \
    --pkg-config-flags="--static" \
    --prefix=../src/opt/ffmpeg
make
make install
cd ..
debuild -rfakeroot -sa -erobot-disk-cloud@yandex-team.ru -I -us -uc -b
