# -*- coding: utf-8 -*-
"""
    Logging settings for mongodb-rs-staletag
"""


CONSOLE_LOGGING = {
    'version': 1,
    'formatters': {
        'console': {
            '()': 'logging.Formatter',
            'format': '  %(asctime)s %(levelname)-8s %(message)s',
            'datefmt': '%H:%M:%S',
        }
    },
    'handlers': {
        'default': {
            'formatter': 'console',
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
        },
    },
    'loggers': {
        'mongodb-rs-staletag': {
            'handlers': ['default'],
            'level': 'INFO',
            'propagate': True
        }
    }
}
