# -*- coding: utf-8 -*-
import os
import fcntl

from .errors import FlockException


class Lockfile(object):
    """Created exclusive lock on given file"""
    def __init__(self, lockfile):
        if not os.path.isfile(lockfile):
            open(lockfile, 'a')
        self.lockfile = open(lockfile)

    def __enter__(self):
        try:
            fcntl.flock(self.lockfile, fcntl.LOCK_EX | fcntl.LOCK_NB)
        except Exception:
            raise FlockException

    def __exit__(self, type, value, traceback):
        self.lockfile.close()


class State(object):
    """MongoDB internal states for nodes"""
    STARTUP = 0
    PRIMARY = 1
    SECONDARY = 2
    RECOVERING = 3
    STARTUP = 5
    UNKNOWN = 6
    ARBITER = 7
    DOWN = 8
    ROLLBACK = 9
    REMOVED = 10
