package main

import (
	"encoding/json"
	"strconv"
)

type Command struct {
	metric string
	exec   string
}

type HistogramBucket struct {
	leftBorder float64
	capacity   int64
}

func (h HistogramBucket) MarshalJSON() ([]byte, error) {
	output := []byte("[")
	output = append(output, []byte(strconv.FormatFloat(h.leftBorder, 'f', 3, 64))...)
	output = append(output, []byte(",")...)
	output = append(output, []byte(strconv.FormatInt(h.capacity, 10))...)
	output = append(output, []byte("]")...)
	return output, nil
}

func (h *HistogramBucket) UnmarshalJSON(b []byte) error {
	var list []json.RawMessage
	err := json.Unmarshal(b, &list)
	if err != nil {
		return err
	}
	err = json.Unmarshal(list[0], &h.leftBorder)
	if err != nil {
		return err
	}
	err = json.Unmarshal(list[1], &h.capacity)
	if err != nil {
		return err
	}
	return nil
}

type Metric struct {
	Name  string
	Hist  []HistogramBucket
	Value float64
}

func (m Metric) MarshalJSON() ([]byte, error) {
	output := []byte("[\"" + m.Name + "\",")
	if len(m.Hist) > 0 {
		jsonHist, err := json.Marshal(m.Hist)
		if err != nil {
			return nil, err
		}
		output = append(output, jsonHist...)
	} else {
		output = append(output, []byte(strconv.FormatFloat(m.Value, 'f', 3, 64))...)
	}
	output = append(output, []byte("]")...)
	return output, nil
}

func (m *Metric) UnmarshalJSON(b []byte) error {
	var list []json.RawMessage
	err := json.Unmarshal(b, &list)
	if err != nil {
		return err
	}
	err = json.Unmarshal(list[0], &m.Name)
	if err != nil {
		return err
	}
	if m.Name[len(m.Name)-1] == 'h' {
		err = json.Unmarshal(list[1], &m.Hist)
		if err != nil {
			return err
		}
	} else {
		err = json.Unmarshal(list[1], &m.Value)
		if err != nil {
			return err
		}
	}
	return nil
}
