package main

import (
	"strings"
)

func getMetric(globalMetricName string, line string) *Metric {
	var metric *Metric
	if strings.Contains(line, "timings") {
		if strings.HasSuffix(globalMetricName, "_counters") {
			metric = Histogram(line, "_dhhh")
		} else {
			metric = Histogram(line, "_ahhh")
		}
	} else if strings.Contains(line, "_hgram") {
		metric = Histogram(line, "_ahhh")
	} else if strings.HasSuffix(globalMetricName, "_stats") {
		metric = LastSumm(line)
	} else if strings.HasSuffix(globalMetricName, "_counters") {
		metric = CountersSumm(line)
	} else {
		metric = AbsoluteSumm(line)
	}
	if metric == nil {
		return nil
	}
	metric.Name = globalMetricName + "_" + metric.Name
	return metric
}

func AbsoluteSumm(line string) *Metric {
	return numericToYasm(line, "_ammm")
}

func CountersSumm(line string) *Metric {
	return numericToYasm(line, "_dmmm")
}

func LastSumm(line string) *Metric {
	return numericToYasm(line, "_tmmv")
}

func Histogram(line, suffix string) *Metric {
	parts := strings.Fields(line)
	if len(parts) < 2 {
		return nil
	}
	name := parts[0]
	var packedTimingsMap map[float64]int64
	var timingsLen int64
	if strings.HasPrefix(name, "@") {
		name = name[1:]
		packedTimingsMap, timingsLen = parsePackedTimings(parts[1:])
	} else {
		packedTimingsMap, timingsLen = parseListTimings(parts[1:])
	}
	bucketSize := timingsLen / 100
	longHistogram := listPackedTimings(packedTimingsMap)

	if len(longHistogram) < 1 {
		return nil
	}
	result := []HistogramBucket{longHistogram[0]}
	for _, bucket := range longHistogram[1:] {
		if result[len(result)-1].capacity > bucketSize {
			result = append(result, bucket)
		} else {
			result[len(result)-1].capacity += bucket.capacity
		}
	}
	return &Metric{
		Name: name + suffix,
		Hist: result,
	}
}
