package main

import (
	"sort"
	"strconv"
	"strings"
)

func numericToYasm(line, suffix string) *Metric {
	parts := strings.Fields(line)
	if len(parts) < 2 {
		return nil
	}
	value, _ := strconv.ParseFloat(parts[1], 64)
	return &Metric{
		Name:  parts[0] + suffix,
		Value: value,
	}
}

func splitPack(element string) (float64, int64) {
	parts := strings.Split(element, "@")
	if len(parts) < 2 {
		return 0.0, 0
	}
	value, err := strconv.ParseFloat(parts[0], 64)
	if err != nil {
		return 0.0, 0
	}
	count, err := strconv.ParseInt(parts[1], 10, 64)
	if err != nil {
		return 0.0, 0
	}
	return value, count

}

func parsePackedTimings(timings []string) (map[float64]int64, int64) {
	counter := make(map[float64]int64)
	timingsLen := int64(0)
	for _, timing := range timings {
		value, count := splitPack(timing)
		counter[value] += count
		timingsLen += count
	}
	return counter, timingsLen
}

func parseListTimings(timings []string) (map[float64]int64, int64) {
	counter := make(map[float64]int64)
	for _, timing := range timings {
		value, err := strconv.ParseFloat(timing, 64)
		if err != nil {
			continue
		}
		counter[value] += 1
	}
	return counter, int64(len(timings))
}

func listPackedTimings(packetTimingsMap map[float64]int64) []HistogramBucket {
	var keys []float64
	for k := range packetTimingsMap {
		keys = append(keys, k)
	}
	sort.Float64s(keys)
	var buckets []HistogramBucket
	for _, k := range keys {
		buckets = append(buckets, HistogramBucket{leftBorder: k, capacity: packetTimingsMap[k]})
	}
	return buckets
}
