import json
import urllib
from datetime import date
from os import getenv

import requests

TESTPALM_URL = "https://testpalm.yandex-team.ru:443/api/testcases/diskclient/preview?expression="
DISK_CLIENT_QUANTITY = 'Disk/Automation/test/Disk_Client_Automation'

# @robot-mabel-pines http://testpalm.yandex-team.ru/internal/profile
TESTPALM_TOKEN = getenv("TESTPALM_TOKEN")
# @robot-mabel-pines https://wiki.yandex-team.ru/statbox/Statface/externalreports/#autentifikacija
STAT_TOKEN = getenv("STAT_TOKEN")

all_cases_query = {"type": "NEQ", "key": "status", "value": "archived"}

smoke_all = {"type": "EQ", "key": "attributes.5cf0fce05316180b7cdaa31e", "value": "Smoke"}
bl_all = {"type": "EQ", "key": "attributes.5cf0fce05316180b7cdaa31e", "value": "Business Logic"}
regression_all = {"type": "EQ", "key": "attributes.5cf0fce05316180b7cdaa31e", "value": "Regression"}

is_autotest = {"type": "EQ", "key": "isAutotest", "value": True}

automated_cases_query = {"type": "AND", "left": all_cases_query, "right": is_autotest}
automated_smoke = {'type': 'AND', 'left': smoke_all, 'right': is_autotest}
automated_bl = {'type': 'AND', 'left': bl_all, 'right': is_autotest}
automated_regression = {'type': 'AND', 'left': regression_all, 'right': is_autotest}


def get_test_cases_by_filter_num(case_filter):
    req_headers = {"TestPalm-Api-Token": TESTPALM_TOKEN, "Content-Type": "application/json"}

    url = TESTPALM_URL + urllib.quote(json.dumps(case_filter, ensure_ascii=False, separators=(",", ": ")))
    params = {'includeFields': 'id', 'excludeFields': 'name,attributes'}
    print(url)

    res = requests.get(url, params=params, headers=req_headers, verify=False)
    cases = res.json()
    print(cases)
    return len(cases)


automated_smoke_quantity = get_test_cases_by_filter_num(case_filter=automated_smoke)
automated_bl_quantity = get_test_cases_by_filter_num(case_filter=automated_bl)
automated_regression_quantity = get_test_cases_by_filter_num(case_filter=automated_regression)
smoke_all_quantity = get_test_cases_by_filter_num(case_filter=smoke_all)
bl_all_quantity = get_test_cases_by_filter_num(case_filter=bl_all)
regression_all_quantity = get_test_cases_by_filter_num(case_filter=regression_all)
all_cases_query = get_test_cases_by_filter_num(case_filter=all_cases_query)
automated_cases_query = get_test_cases_by_filter_num(case_filter=automated_cases_query)

print(automated_smoke_quantity)
print(automated_bl_quantity)
print(automated_regression_quantity)
print(smoke_all_quantity)
print(bl_all_quantity)
print(regression_all_quantity)
print(all_cases_query)
print(automated_cases_query)


today = date.today().isoformat()
print("Used date: " + today)

data = [
    {
        "fielddate": today,
        "automated_smoke_quantity": automated_smoke_quantity,
        "automated_bl_quantity": automated_bl_quantity,
        "automated_regression_quantity": automated_regression_quantity,
        "smoke_all_quantity": smoke_all_quantity,
        "bl_all_quantity": bl_all_quantity,
        "regression_all_quantity": regression_all_quantity,
        "all_cases_query": all_cases_query,
        "automated_cases_query": automated_cases_query
    }
]

r = requests.post(
    'https://upload.stat.yandex-team.ru/_api/report/data',
    headers={'Authorization': 'OAuth %s' % STAT_TOKEN},
    data={
        'name': DISK_CLIENT_QUANTITY,
        'scale': 'd',
        'data': json.dumps({'values': data}),
    },
)

print (r.text.encode('utf-8'))
