import json
import urllib
from datetime import date
from os import getenv

import requests

TESTPALM_URL = "https://testpalm.yandex-team.ru:443/api/testcases/diskpublic/preview?expression="
DISK_CLIENT_QUANTITY = 'Disk/Automation/test/Disk_Public_Automation'

# @robot-mabel-pines http://testpalm.yandex-team.ru/internal/profile
TESTPALM_TOKEN = getenv("TESTPALM_TOKEN")
# @robot-mabel-pines https://wiki.yandex-team.ru/statbox/Statface/externalreports/#autentifikacija
STAT_TOKEN = getenv("STAT_TOKEN")

all_cases_query = {"type": "NEQ", "key": "status", "value": "archived"}
smoke_all = {"type": "EQ", "key": "attributes.5c5179c22a78680b9e7ed848", "value": "Smoke"}

is_autotest = {"type": "EQ", "key": "isAutotest", "value": True}

automated_cases_query = {"type": "AND", "left": all_cases_query, "right": is_autotest}
automated_smoke = {'type': 'AND', 'left': smoke_all, 'right': is_autotest}


def get_test_cases_by_filter_num(case_filter):
    req_headers = {"TestPalm-Api-Token": TESTPALM_TOKEN, "Content-Type": "application/json"}

    url = TESTPALM_URL + urllib.quote(json.dumps(case_filter, ensure_ascii=False, separators=(",", ": ")))
    params = {'includeFields': 'id', 'excludeFields': 'name,attributes'}
    print(url)

    res = requests.get(url, params=params, headers=req_headers, verify=False)
    cases = res.json()
    print(cases)
    return len(cases)


automated_smoke_quantity = get_test_cases_by_filter_num(case_filter=automated_smoke)
smoke_all_quantity = get_test_cases_by_filter_num(case_filter=smoke_all)
all_cases_query = get_test_cases_by_filter_num(case_filter=all_cases_query)
automated_cases_query = get_test_cases_by_filter_num(case_filter=automated_cases_query)

print(automated_smoke_quantity)
print(smoke_all_quantity)
print(all_cases_query)
print(automated_cases_query)


today = date.today().isoformat()
print("Used date: " + today)

data = [
    {
        "fielddate": today,
        "automated_smoke_quantity": automated_smoke_quantity,
        "smoke_all_quantity": smoke_all_quantity,
        "all_cases_query": all_cases_query,
        "automated_cases_query": automated_cases_query
    }
]

r = requests.post(
    'https://upload.stat.yandex-team.ru/_api/report/data',
    headers={'Authorization': 'OAuth %s' % STAT_TOKEN},
    data={
        'name': DISK_CLIENT_QUANTITY,
        'scale': 'd',
        'data': json.dumps({'values': data}),
    },
)

print (r.text.encode('utf-8'))
