import os
import sys
from datetime import datetime, timedelta

import logging
logging.basicConfig(level=logging.INFO, format="[%(asctime)s] %(levelname)s %(name)s %(message)s")
logger = logging.getLogger(__name__)

from yql.api.v1.client import YqlClient

parent_dir_path = '/'.join(os.path.abspath(__file__).split('/')[:-2])
sys.path = [parent_dir_path] + sys.path

from common.juggler import send_juggler

MAX_COUNT = int(os.getenv('MAX_COUNT'))
YQL_TOKEN = os.getenv("YQL_TOKEN")

query = """USE hahn;
$capture_operation_details = Re2::Capture('.*uid: ([^ ]+)');


SELECT count(DISTINCT $capture_operation_details(message)._1)
FROM `logs/ydisk-mpfs-default-log/1d/%s`
WHERE appname = 'queue2' and message like '%%RAM limit is reached by uid%%'
;"""


if __name__ == '__main__':
    client = YqlClient(token=YQL_TOKEN)
    yesterday = os.getenv("DAY_FOR_COUNT") or (datetime.today() - timedelta(days=1)).strftime('%Y-%m-%d')
    request = client.query(query % yesterday, syntax_version=1)
    request.run()
    logger.info('YQL request run: %s' % request.share_url)
    count = 0
    for table in request.get_results():
        count += table.rows[0][0]
    if count >= MAX_COUNT:
        send_juggler('disk_mworker_devops', 'operation_oom', 'CRIT', 'OOMed_daily_operation_is_over_limit')
    else:
        send_juggler('disk_mworker_devops', 'operation_oom', 'OK', 'OK')
