#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
import requests

from os import getenv

"""
 https://wiki.yandex-team.ru/intranet/abc/docs/api/     - wiki с описанием
 https://abc-back.yandex-team.ru/api/swagger/           - swagger api
"""


class YandexAbcClient(object):
    URL = 'https://abc-back.yandex-team.ru/api/v4/{endpoint}'

    def __init__(self, token):
        self.headers = {
            'Authorization': 'OAuth {}'.format(token),
            'user-agent': 'disk.admin.monitors.common.YandexAbcClient (GSID: %s)'
                          % getenv('GSID', '').replace('\n', ' '),
        }

    def _get(self, endpoint, params, retries=3):
        url = self.URL.format(endpoint=endpoint)
        for attempt in range(retries):
            try:
                response = requests.get(url, params=params, headers=self.headers)
                response.raise_for_status()
            except Exception as e:
                print(e)
                continue
            else:
                return response
        return None

    def get_shifts(self, schedule_id, date_from, date_to):
        query_params = {
            'schedule': schedule_id,
            'date_from': date_from,
            'date_to': date_to
        }
        response = self._get('duty/shifts/', query_params)
        print "get_shifts", response

        if not response:
            return []
        if response.status_code != 200:
            print(response.text)
            return []
        return response.json()['results']

    def get_current_duty(self, service_slug, schedule_slug):
        query_params = {
            'service__slug': service_slug,
            'schedule__slug': schedule_slug
        }
        response = self._get('duty/on_duty/', query_params)
        print "get_current_duty", response

        if not response:
            return []
        if response.status_code != 200:
            print(response.text)
            return []
        return [u['person']['login'] for u in response.json()]
