#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

import socket
import time
import logging

hosts = ["gr.mega-graphite-man.search.yandex.net", "gr.mega-graphite-sas.search.yandex.net"]
port = 2024


def send_batch(metrics):
    line = ""
    for metric in metrics:
        message = format_message(metric[0], metric[1])

        logging.info("Send graphite %s" % message)
        line += message

    send_raw_to_all(line)


def send_one(metric_name, value):
    message = format_message(metric_name, value)

    logging.info("Send graphite %s" % message)
    send_raw_to_all(message)


def format_message(metric_name, value):
    return "%s %s %d\n" % (metric_name, str(value), int(time.time()))


def send_raw_to_all(message):
    for host in hosts:
        send_raw_to_one(host, message)


def send_raw_to_one(host, message):
    try:
        sock = socket.socket(socket.AF_INET6, socket.SOCK_STREAM, 0)
        sock.settimeout(10)
        sock.connect((host, port, 0, 0))
        sock.sendall(message)
        sock.close()
    except Exception as e:
        logging.error("Failed to send data: %s" % str(e))
