# -*- coding: utf-8 -*-


def html_table(t, headers):
    table = [u"<table cellpadding=10 style='border-collapse: collapse; word-break: keep-all;'>\n",
             u"<tr style='border-top: 0; border-bottom: 2px solid black;'>"]
    for header in headers:
        if isinstance(header, basestring):
            table.append(u"<th>%s</th>" % header.title())
        else:
            table.append(u"<th>%s</th>" % header[0])
    table.append(u"</tr>\n")

    for i, row in enumerate(t):
        table.append(u"<tr %s>" % (u"style='background: #f7f7f7;'" if i % 2 else ""))
        for key in headers:
            if isinstance(key, basestring):
                value = row[key]
            else:
                if isinstance(key[1], basestring):
                    value = row[key[1]]
                else:
                    value = key[1](row)
            table.append(u"<td>%s</td>" % str(value).decode('utf8'))
        table.append(u"</tr>\n")
    table.append(u"</table>")
    return u"".join(table)
