#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
import logging

import requests

from os import getenv


def crit(message=''):
    return 'CRIT', message


def warn(message=''):
    return 'WARN', message


def ok(message=''):
    return 'OK', message


def send_juggler(host, service, status, description):
    try:
        reply = requests.post(
            "http://juggler-push.search.yandex.net/events",
            json={
                "source": "sandbox",
                "events": [{
                    "host": host,
                    "service": service,
                    "status": status,
                    "description": description
                }]
            },
            headers={
                'user-agent': 'disk.admin.monitors.common.juggler (GSID: %s)' % getenv('GSID', '').replace('\n', ' '),
            },
        )
        event_status = reply.json()["events"][0]
        if event_status["code"] != 200:
            raise Exception(event_status["error"])
        logging.info("event host=%s service=%s status=%s sent" % (host, service, status))
    except Exception:
        logging.exception("unable to send juggler event")
