#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
import requests

from os import getenv


class YandexStaffClient(object):
    URL = 'https://staff-api.yandex-team.ru/v3/{endpoint}'

    def __init__(self, token):
        self.headers = {
            'Authorization': 'OAuth {}'.format(token),
            'user-agent': 'disk.admin.monitors.common.YandexStaffClient (GSID: %s)'
                          % getenv('GSID', '').replace('\n', ' '),
        }

    def _get(self, endpoint, params, retries=3):
        url = self.URL.format(endpoint=endpoint)
        for attempt in range(retries):
            try:
                response = requests.get(url, params=params, headers=self.headers)
                response.raise_for_status()
            except Exception as e:
                print(e)
                continue
            else:
                return response
        return None

    def get_group_members(self, department):
        query_params = {
            'groups.group.url': department,
            'official.is_dismissed': 'false',
            '_limit': 500,
            '_fields': 'login'
        }
        response = self._get('persons', query_params)
        if not response:
            return []
        if response.status_code != 200:
            print(response.text)
            return []
        return [u['login'] for u in response.json()['result']]

    def get_users_by_groups(self, departments):
        users = set()
        for department in departments:
            users.update(self.get_group_members(department))
        return users
