#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

import logging
from os import getenv
from bazinga_counter import BazingaCounter
from juggler import send_juggler, ok

logging.basicConfig(level=logging.INFO)


def basic_parse_thresholds(thresholds):
    if isinstance(thresholds, str):
        return [int(i) for i in
                thresholds.replace(';', ' ').replace(',', ' ')
                .replace(':', ' ').split()]
    return []


class TasksCountChecker(object):
    def __init__(self, default_task_name, default_juggler_host, service_name=None):
        super(TasksCountChecker, self).__init__()

        pg_group = getenv('PG_GROUP', 'disk_diskq_db').strip('%')
        pg_user = getenv('PG_USER')
        pg_pass = getenv('PG_PASS')
        pg_db = getenv('PG_DB', 'diskqdb')
        pg_port = getenv('PG_PORT', '6432')
        self.thresholds = self.parse_thresholds(getenv('THRESHOLDS'))

        self.task_name = getenv('TASK_NAME', default_task_name)

        self.service_name = service_name or self.task_name

        self.juggler_host = getenv('JUGGLER_HOST', default_juggler_host)

        self.bazinga_counter = BazingaCounter(pg_group, pg_user, pg_pass,
                                              pg_db, pg_port)

    def parse_thresholds(self, thresholds):
        return basic_parse_thresholds(thresholds)

    def check(self, tasks_num):
        return ok('')

    def get_count_check(self):
        tasks_num = self.bazinga_counter.count_bazinga(self.task_name)
        return self.check(tasks_num)

    def get_count_check_and_send(self):
        status, text = self.get_count_check()
        send_juggler(self.juggler_host, self.service_name, status, text)
