#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

import logging

from common.tasks_count_checker import TasksCountChecker
from common.juggler import ok, warn, crit

logging.basicConfig(level=logging.INFO)


JUGGLER_SETUP = {
    'OK': (ok, logging.info),
    'WARN': (warn, logging.info),
    'CRIT': (crit, logging.critical)
}


def log_and_return(level, number, threshold):
    if number >= threshold:
        sign = '>='
        text = 'not less than'
    else:
        sign = '<'
        text = 'less than'
    j, l = JUGGLER_SETUP[level]
    l(level + ": %d %s %d" % (number, sign, threshold))

    return j("`{}` {} `{}`".format(number, text, threshold))


class DeltasChecker(TasksCountChecker):
    def __init__(self):
        super(DeltasChecker, self).__init__('deltasCleaning',
                                            'disk_dataapi_worker_devops',
                                            'deltasCleaningMorning')

    def check(self, tasks_num):
        if len(self.thresholds) < 2:
            logging.critical("You need to pass env THRESHOLDS=0,1" +
                             " for warn and critical levels")

            return warn("Misconfigured script")

        if tasks_num > self.thresholds[1]:
            return log_and_return('CRIT', tasks_num, self.thresholds[1])
        elif tasks_num > self.thresholds[0]:
            return log_and_return('WARN', tasks_num, self.thresholds[0])
        else:
            return log_and_return('OK', tasks_num, self.thresholds[0])


if __name__ == '__main__':
    checker = DeltasChecker()
    checker.get_count_check_and_send()
