#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

import logging

from common.tasks_count_checker import TasksCountChecker
from deltas_cleaning_morning import log_and_return

logging.basicConfig(level=logging.INFO)

class DeltasChecker(TasksCountChecker):
    def __init__(self):
        super(DeltasChecker, self).__init__('deltasCleaning',
                                            'disk_dataapi_worker_devops',
                                            'deltasCleaningNight')

    def check(self, tasks_num):
        if tasks_num < 1:
            return log_and_return('CRIT', tasks_num, 1)
        else:
            return log_and_return('OK', tasks_num, 1)


if __name__ == '__main__':
    checker = DeltasChecker()
    checker.get_count_check_and_send()
